pl#!/bin/sh
# In this file are iptables rules which block all incoming and outgoing traffic to commonly used hosting providers (such as OVH and Leaseweb).
# The reason why, in my opinion, you should block these sites is because they can form a potential security threat to all the private ones out there.
# People should not support rented sites and we should not encourage people to use them, therefore we should block them instead.

echo -e "This script will add IP ranges of commonly used hosting providers (such as OVH and Leaseweb) to host rented sites to iptables in order to block all traffic from and to them.\n"
read -p "Press any key to add the banned IP ranges..."
echo -e "Adding banned IP ranges to iptables...\n"

############### INCOMING TRAFFIC ##############
# OVH - www.ovh.fr

iptables -A INPUT -s 87.98.128.0/17 -j DROP
iptables -A INPUT -s 91.121.0.0/16 -j DROP
iptables -A INPUT -s 94.23.0.0/16 -j DROP
iptables -A INPUT -s 178.32.0.0/15 -j DROP
iptables -A INPUT -s 188.165.0.0/16 -j DROP
iptables -A INPUT -s 213.186.32.0/19 -j DROP
iptables -A INPUT -s 213.251.128.0/18 -j DROP

# LEASEWEB - www.leaseweb.nl

iptables -A INPUT -s 62.212.64.0/19 -j DROP
iptables -A INPUT -s 82.192.64.0/19 -j DROP
iptables -A INPUT -s 83.149.64.0/18 -j DROP
iptables -A INPUT -s 85.17.0.0/16 -j DROP
iptables -A INPUT -s 95.211.0.0/16 -j DROP

# WORLDSTREAM - www.worldstream.nl

iptables -A INPUT -s 93.190.136.0/22 -j DROP
iptables -A INPUT -s 109.236.80.0/20 -j DROP
iptables -A INPUT -s 217.23.0.0/20 -j DROP

# ROOT ESOLUTIONS - www.root.lu

iptables -A INPUT -s 94.242.192.0/18 -j DROP
iptables -A INPUT -s 212.117.160.0/19 -j DROP

# AQUATIX IT SERVICES - www.aquatix.de

iptables -A INPUT -s 62.93.0.0/19 -j DROP
iptables -A INPUT -s 91.211.8.0/22 -j DROP
iptables -A INPUT -s 91.200.108.0/22 -j DROP
iptables -A INPUT -s 109.75.96.0/20 -j DROP
iptables -A INPUT -s 195.230.108.0/24 -j DROP

# UK2 - www.uk2.net

iptables -A INPUT -s 83.170.96.0/20 -j DROP
iptables -A INPUT -s 83.170.64.0/18 -j DROP
iptables -A INPUT -s 212.134.0.0/15 -j DROP

# LAYAREDTECH - www.layeredtech.com

iptables -A INPUT -s 72.232.0.0/16 -j DROP
iptables -A INPUT -s 72.233.0.0/17 -j DROP

# GRAFIX - www.grafix.nl

iptables -A INPUT -s 84.243.192.0/18 -j DROP
iptables -A INPUT -s 217.67.224.0/19 -j DROP

# THE PLANET - www.theplanet.com

iptables -A INPUT -s 70.84.0.0/14 -j DROP

# FHE3 - www.fhe3.com

iptables -A INPUT -s 82.98.86.0/24 -j DROP

# PLUSLINE - www.plusline.net

iptables -A INPUT -s 212.19.32.0/19 -j DROP
iptables -A INPUT -s 213.83.0.0/18 -j DROP
iptables -A INPUT -s 82.98.86.0/24 -j DROP

# BIT B.V. - www.bit.nl

iptables -A INPUT -s 213.83.0.0/18 -j DROP
iptables -A INPUT -s 212.19.32.0/19 -j DROP
iptables -A INPUT -s 213.154.224.0/19 -j DROP

# SILVER SERVER - www.sil.at

iptables -A INPUT -s 78.142.128.0/18 -j DROP
iptables -A INPUT -s 86.59.0.0/17 -j DROP

# SOLOGIGABIT - www.sologigabit.nl

iptables -A INPUT -s 84.243.202.0/24 -j DROP
iptables -A INPUT -s 84.243.213.0/24 -j DROP

# GREATNET - www.greatnet.de

iptables -A INPUT -s 83.133.96.0/19 -j DROP

# ID3 - www.id3.net

iptables -A INPUT -s 84.244.128.0/18 -j DROP
iptables -A INPUT -s 84.244.160.0/19 -j DROP
iptables -A INPUT -s 217.148.160.0/20 -j DROP
iptables -A INPUT -s 217.148.176.0/20 -j DROP

# RAPIDSWITCH - www.rapidswitch.com

iptables -A INPUT -s 78.129.128.0/17 -j DROP
iptables -A INPUT -s 87.117.192.0/18 -j DROP
iptables -A INPUT -s 193.201.200.0/23 -j DROP
iptables -A INPUT -s 194.150.120.0/22 -j DROP
iptables -A INPUT -s 195.62.10.0/23 -j DROP
iptables -A INPUT -s 217.147.80.0/20 -j DROP

# KEYWEB - www.keyweb.de

iptables -A INPUT -s 62.141.48.0/20 -j DROP
iptables -A INPUT -s 84.19.160.0/19 -j DROP
iptables -A INPUT -s 87.118.64.0/18 -j DROP
iptables -A INPUT -s 95.169.160.0/19 -j DROP
iptables -A INPUT -s 195.34.82.0/24 -j DROP

# UNITED COLO - www.unitedcolo.de

iptables -A INPUT -s 85.14.192.0/18 -j DROP

# HETZNER - www.hetzner.de

iptables -A INPUT -s 88.198.0.0/16 -j DROP
iptables -A INPUT -s 213.133.96.0/19 -j DROP

# GIGA-HOSTING - www.giga-hosting.biz

iptables -A INPUT -s 91.194.90.0/23 -j DROP
iptables -A INPUT -s 91.205.172.0/22 -j DROP
iptables -A INPUT -s 93.104.208.0/21 -j DROP
iptables -A INPUT -s 193.37.152.0/24 -j DROP
iptables -A INPUT -s 193.164.132.0/23 -j DROP
iptables -A INPUT -s 193.200.241.0/24 -j DROP

# LIGHTUP - www.lightup.de

iptables -A INPUT -s 217.172.32.0/19 -j DROP

# NFOrce Entertainment BV - www.nforce.nl

iptables -A INPUT -s 77.247.176.0/21 -j DROP

# BlueSquare Data - bluesquaredata.com

iptables -A INPUT -s 91.186.0.0/19 -j DROP

# Gogax - www.gogax.com

iptables -A INPUT -s 208.66.68.0/22 -j DROP

# Nessus - www.nessus.at

iptables -A INPUT -s 77.244.240.0/20 -j DROP

# SERVER4YOU Dedicated Server Hosting - www.server4you.de

iptables -A INPUT -s 62.75.128.0/17 -j DROP

# ISP Services B.V. - www.isp-services.nl

iptables -A INPUT -s  212.79.224.0/19 -j DROP

# Infolink - www.infolink.com

iptables -A INPUT -s 200.35.144/21 -j DROP

# PRQ - www.prq.se

iptables -A INPUT -s 88.80.0.0/19 -j DROP

# Real Hosts - www.real-hosts.com
iptables -A INPUT -s 93.189.0.0/21 -j DROP

# Rapidswitch - www.rapidswitch.com
iptables -A INPUT -s 95.154.192.0/18 -j DROP

############### OUTGOING TRAFFIC ##############
# OVH - www.ovh.fr

iptables -A OUTPUT -s 87.98.128.0/17 -j DROP
iptables -A OUTPUT -s 91.121.0.0/16 -j DROP
iptables -A OUTPUT -s 94.23.0.0/16 -j DROP
iptables -A OUTPUT -s 178.32.0.0/15 -j DROP
iptables -A OUTPUT -s 188.165.0.0/16 -j DROP
iptables -A OUTPUT -s 213.186.32.0/19 -j DROP
iptables -A OUTPUT -s 213.251.128.0/18 -j DROP

# LEASEWEB - www.leaseweb.nl

iptables -A OUTPUT -s 62.212.64.0/19 -j DROP
iptables -A OUTPUT -s 82.192.64.0/19 -j DROP
iptables -A OUTPUT -s 83.149.64.0/18 -j DROP
iptables -A OUTPUT -s 85.17.0.0/16 -j DROP
iptables -A OUTPUT -s 95.211.0.0/16 -j DROP

# WORLDSTREAM - www.worldstream.nl

iptables -A OUTPUT -s 93.190.136.0/22 -j DROP
iptables -A OUTPUT -s 109.236.80.0/20 -j DROP
iptables -A OUTPUT -s 217.23.0.0/20 -j DROP

# ROOT ESOLUTIONS - www.root.lu

iptables -A OUTPUT -s 94.242.192.0/18 -j DROP
iptables -A OUTPUT -s 212.117.160.0/19 -j DROP

# AQUATIX IT SERVICES - www.aquatix.de

iptables -A OUTPUT -s 62.93.0.0/19 -j DROP
iptables -A OUTPUT -s 91.211.8.0/22 -j DROP
iptables -A OUTPUT -s 91.200.108.0/22 -j DROP
iptables -A OUTPUT -s 109.75.96.0/20 -j DROP
iptables -A OUTPUT -s 195.230.108.0/24 -j DROP

# UK2 - www.uk2.net

iptables -A OUTPUT -s 83.170.96.0/20 -j DROP
iptables -A OUTPUT -s 83.170.64.0/18 -j DROP
iptables -A OUTPUT -s 212.134.0.0/15 -j DROP

# LAYAREDTECH - www.layeredtech.com

iptables -A OUTPUT -s 72.232.0.0/16 -j DROP
iptables -A OUTPUT -s 72.233.0.0/17 -j DROP

# GRAFIX - www.grafix.nl

iptables -A OUTPUT -s 84.243.192.0/18 -j DROP
iptables -A OUTPUT -s 217.67.224.0/19 -j DROP

# THE PLANET - www.theplanet.com

iptables -A OUTPUT -s 70.84.0.0/14 -j DROP

# FHE3 - www.fhe3.com

iptables -A OUTPUT -s 82.98.86.0/24 -j DROP

# PLUSLINE - www.plusline.net

iptables -A OUTPUT -s 212.19.32.0/19 -j DROP
iptables -A OUTPUT -s 213.83.0.0/18 -j DROP
iptables -A INPUT -s 82.98.86.0/24 -j DROP

# BIT B.V. - www.bit.nl

iptables -A OUTPUT -s 213.83.0.0/18 -j DROP
iptables -A OUTPUT -s 212.19.32.0/19 -j DROP
iptables -A OUTPUT -s 213.154.224.0/19 -j DROP

# SILVER SERVER - www.sil.at

iptables -A OUTPUT -s 78.142.128.0/18 -j DROP
iptables -A OUTPUT -s 86.59.0.0/17 -j DROP

# SOLOGIGABIT - www.sologigabit.nl

iptables -A OUTPUT -s 84.243.202.0/24 -j DROP
iptables -A OUTPUT -s 84.243.213.0/24 -j DROP

# GREATNET - www.greatnet.de

iptables -A OUTPUT -s 83.133.96.0/19 -j DROP

# ID3 - www.id3.net

iptables -A OUTPUT -s 84.244.128.0/18 -j DROP
iptables -A OUTPUT -s 84.244.160.0/19 -j DROP
iptables -A OUTPUT -s 217.148.160.0/20 -j DROP
iptables -A OUTPUT -s 217.148.176.0/20 -j DROP

# RAPIDSWITCH - www.rapidswitch.com

iptables -A OUTPUT -s 78.129.128.0/17 -j DROP
iptables -A OUTPUT -s 87.117.192.0/18 -j DROP
iptables -A OUTPUT -s 193.201.200.0/23 -j DROP
iptables -A OUTPUT -s 194.150.120.0/22 -j DROP
iptables -A OUTPUT -s 195.62.10.0/23 -j DROP
iptables -A OUTPUT -s 217.147.80.0/20 -j DROP

# KEYWEB - www.keyweb.de

iptables -A OUTPUT -s 62.141.48.0/20 -j DROP
iptables -A OUTPUT -s 84.19.160.0/19 -j DROP
iptables -A OUTPUT -s 87.118.64.0/18 -j DROP
iptables -A OUTPUT -s 95.169.160.0/19 -j DROP
iptables -A OUTPUT -s 195.34.82.0/24 -j DROP

# UNITED COLO - www.unitedcolo.de

iptables -A OUTPUT -s 85.14.192.0/18 -j DROP

# HETZNER - www.hetzner.de

iptables -A OUTPUT -s 88.198.0.0/16 -j DROP
iptables -A OUTPUT -s 213.133.96.0/19 -j DROP

# GIGA-HOSTING - www.giga-hosting.biz

iptables -A OUTPUT -s 91.194.90.0/23 -j DROP
iptables -A OUTPUT -s 91.205.172.0/22 -j DROP
iptables -A OUTPUT -s 93.104.208.0/21 -j DROP
iptables -A OUTPUT -s 193.37.152.0/24 -j DROP
iptables -A OUTPUT -s 193.164.132.0/23 -j DROP
iptables -A OUTPUT -s 193.200.241.0/24 -j DROP

# LIGHTUP - www.lightup.de

iptables -A OUTPUT -s 217.172.32.0/19 -j DROP

# NFOrce Entertainment BV - www.nforce.nl

iptables -A OUTPUT -s 77.247.176.0/21 -j DROP

# BlueSquare Data - bluesquaredata.com

iptables -A OUTPUT -s 91.186.0.0/19 -j DROP

# Gogax - www.gogax.com

iptables -A OUTPUT -s 208.66.68.0/22 -j DROP

# Nessus - www.nessus.at

iptables -A OUTPUT -s 77.244.240.0/20 -j DROP

# SERVER4YOU Dedicated Server Hosting - www.server4you.de

iptables -A OUTPUT -s 62.75.128.0/17 -j DROP

# ISP Services B.V. - www.isp-services.nl

iptables -A OUTPUT -s  212.79.224.0/19 -j DROP

# Infolink - www.infolink.com

iptables -A OUTPUT -s 200.35.144/21 -j DROP

# PRQ - www.prq.se

iptables -A OUTPUT -s 88.80.0.0/19 -j DROP

# Real Hosts - www.real-hosts.com
iptables -A OUTPUT -s 93.189.0.0/21 -j DROP

# Rapidswitch - www.rapidswitch.com
iptables -A OUTPUT -s 95.154.192.0/18 -j DROP

echo -e "Now we have to save the iptables entries.\n"
read -p "Press any key to save the iptables entries to ipbans.fw"
iptables-save > ipbans.fw
echo -e "After finishing this script move the ipbans.fw to your desired location."
echo -e "For Debian/Fedora/Redhat open up rc.local and add the following line:\n"
echo -e "iptables-restore < /<yourlocation>/ipbans.fw\n"
echo -e "Save rc.local, upon a reboot the ip bans are restored.\n"
echo -e "Congratulations! You just made your site a little more secure! :)\n"
read -p "Press any key to exit..."