/* Copyright (c) 1995-1999 NEC USA, Inc.  All rights reserved.               */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("Copyright") included with this distribution.                   */

/*
 * $Id: udputil.h,v 1.22.4.3 1999/02/23 16:41:44 wlu Exp $
 */

/* This file contains all the prototypes for the udp utility functions       */
#ifndef UDPUTIL_H
#define UDPUTIL_H

#include "socks5api.h"
#include "sident.h"

/* socks cache -- which addresses are those of socks servers? (for recvfrom) */
/* Also, need to know if this guy is probly still alive or not...XXX not?    */
struct scache {
    S5NetAddr tcpsin; /* the server's tcp address, where we connected...     */
    S5NetAddr udpsin; /* the server's udp address, where we sendto...        */
    S5IOInfo cinfo;   /* connection info for this server.                    */
    char name[S5_HOSTNAME_SIZE];
    u_char reserved;
    char idtentry[IDTENTRY_SIZE];
    struct scache *next;
};

typedef struct scache UdpSocksCache;

/* authentication cache -- have I sent a message to you before?  If not I    */
/* won't be allowing this message to be recv'd from you.                     */
struct acache {
    S5NetAddr addr; /* remote server's address...                            */
    char name[S5_HOSTNAME_SIZE];  /* remote server's name...                 */
    S5NetAddr baddr; /* last socks5 server's outbound address              */
    int bounded; /* address in bndAddr is valid                              */
    struct acache *next;
};

typedef struct acache UdpAuthCache;

/* route cacche...what socket to write out on (dest)                         */
struct aroute {
    S5NetAddr raddr;      /* The address of the interface...                 */
    S5IOHandle sd;	  /* The socket to use...                            */
  
    struct aroute *next;
};

typedef struct aroute UdpRouteCache;

struct hinfo {
    char name[MAXHOSTNAMELEN];
    struct in_addr addr;
    struct hinfo *next;
};

typedef struct hinfo UdpHostCache;

struct sdring {
    S5IOHandle sd;
    struct sdring *next;
};

typedef struct sdring UdpSdRing;

struct udpinfo {
    S5IOInfo iio, *oiop;
    
    UdpSocksCache *scache;
    UdpAuthCache  *acache;
    UdpRouteCache *rcache;
    UdpHostCache  *hcache;
    
    UdpSocksCache *curs;
    UdpAuthCache  *cura;
    UdpRouteCache *curr;

    UdpSdRing     *sdring;

    char mbuf[UDP_MAX_PAYLOAD + MAXHDRSIZE], *obuf;
    int obuflen;

    S5IOHandle maxfd, relay;
    fd_set myfds;
};

typedef struct udpinfo UdpInfo;


S5IOHandle MakeOutSocket   P((UdpInfo *, S5NetAddr *, u_short));
S5IOHandle FindOutSocket   P((UdpInfo *, S5LinkInfo *, const S5NetAddr *, const char *));

int        FindProxyEntry  P((UdpInfo *, S5LinkInfo *, S5NetAddr *, int));
int        CheckIfAllowed  P((UdpInfo *, S5LinkInfo *));        /* See if host is allowed; cache  */
int        CheckIfCached   P((UdpInfo *, S5LinkInfo *, int));   /* Check cache to see if allowed  */

int        WasResolved     P((UdpInfo *, S5NetAddr *, char *)); /* See if dst was resolved here.  */
void       MarkResolved    P((UdpInfo *, S5NetAddr *, char *)); /* Mark dst was resolved here.    */

#endif 
