/* Copyright (c) 1995-1999 NEC USA, Inc.  All rights reserved.               */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("Copyright") included with this distribution.                   */

/*
 * $Id: daemon.h,v 1.15.4.5 1999/02/23 16:38:16 wlu Exp $
 */

#ifndef DAEMON_H
#define DAEMON_H

#include "addr.h"
#include "buffer.h"
#include "threads.h"

#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

#ifndef MAXCLIENTS
#ifndef _SC_CHILD_MAX
#define MAXCLIENTS 64
#else
#define MAXCLIENTS sysconf(_SC_CHILD_MAX)
#endif
#endif

#ifndef MAXOPENS
#ifndef _SC_OPEN_MAX
#define MAXOPENS 64
#else
#define MAXOPENS sysconf(_SC_OPEN_MAX)
#endif
#endif

#ifndef EXIT_OK
#define EXIT_OK   0 /* Exit status should be 0, we were exiting ok.          */
#endif

#ifndef EXIT_ERR
#define EXIT_ERR -1 /* Exit status should be -1, we weren't too happy.       */
#endif

#ifndef EXIT_AUTH
#define EXIT_AUTH -2 /* Exit status should be -2, exit'd because of auth     */
#endif

#ifndef EXIT_NETERR
#define EXIT_NETERR -3 /* Exit status should be -3, exit'd because of net failure  */
#endif

extern int nthreads;
extern int nservers;
extern int servermode;
extern int idletimeout;
extern char *bindif;
extern u_short ludpport;
extern u_short hudpport;

#define NORMAL     0x00
#define INETD      0x01
#define PREFORKING 0x02
#define SINGLESHOT 0x03
#define THREADED   0x04

IFTHREADED(extern MUTEX_T accept_mutex;)
IFTHREADED(extern MUTEX_T conn_mutex;)
IFTHREADED(extern MUTEX_T env_mutex;)
IFTHREADED(extern MUTEX_T gpw_mutex;)
IFTHREADED(extern MUTEX_T gh_mutex;)
IFTHREADED(extern MUTEX_T gs_mutex;)
IFTHREADED(extern MUTEX_T lt_mutex;)

#endif
