/* Copyright (c) 1995-1999 NEC USA, Inc.  All rights reserved.               */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("Copyright") included with this distribution.                   */

/*
 * $Id: system.h,v 1.20.4.7 1999/08/02 14:59:06 wlu Exp $
 */

#ifndef SYSTEM_H
#define SYSTEM_H

#ifdef IN_LIBRARY
#ifdef HAVE_DLOPEN

/* If we're building the shared library, we need to be able to call the      */
/* "real" functions using dl*.  These are the stubs for those functions.     */
#ifdef FOR_SHARED_LIBRARY

#define REAL(x)       _RLD_ ## x
#define LIBPREFIX(x)  x

#ifdef HAVE_GETHOSTBYNAME2
struct hostent * REAL(gethostbyname2) P((const char *, int));
#endif
struct hostent * REAL(gethostbyname) P((const char *));
struct hostent * REAL(gethostbyaddr) P((const void *, int, int));
struct servent * REAL(getservbyname) P((const char *, const char *)); 

int              REAL(getpeername)  P((S5IOHandle, struct sockaddr *, int *));
int              REAL(getsockname)  P((S5IOHandle, struct sockaddr *, int *));

int              REAL(bind)         P((S5IOHandle, const struct sockaddr *, int));
int              REAL(connect)      P((S5IOHandle, const struct sockaddr *, int));
int              REAL(accept)       P((S5IOHandle, struct sockaddr *, int *));
int              REAL(listen)       P((S5IOHandle, int));

int              REAL(select)       P((S5IOHandle, fd_set *, fd_set *, fd_set *, struct timeval *));
int              REAL(rresvport)    P((int *));

IORETTYPE        REAL(read)         P((S5IOHandle,       IOPTRTYPE, IOLENTYPE));
IORETTYPE        REAL(write)        P((S5IOHandle, const IOPTRTYPE, IOLENTYPE));
IORETTYPE        REAL(recv)         P((S5IOHandle,       IOPTRTYPE, IOLENTYPE, int));
IORETTYPE        REAL(send)         P((S5IOHandle, const IOPTRTYPE, IOLENTYPE, int));
IORETTYPE        REAL(recvfrom)     P((S5IOHandle,       IOPTRTYPE, IOLENTYPE, int,       struct sockaddr *, int *));
IORETTYPE        REAL(sendto)       P((S5IOHandle, const IOPTRTYPE, IOLENTYPE, int, const struct sockaddr *, int));

#ifdef HAVE_SENDMSG
IORETTYPE        REAL(recvmsg)     P((S5IOHandle,const struct msghdr *, int ));
IORETTYPE        REAL(sendmsg)     P((S5IOHandle,const struct msghdr *, int ));
#endif

S5IOHandle       REAL(dup)          P((S5IOHandle));
S5IOHandle       REAL(dup2)         P((S5IOHandle, S5IOHandle));

struct tm *      REAL(localtime)    P((const time_t *));
void             REAL(longjmp)      P((jmp_buf, int));
int              REAL(close)        P((S5IOHandle));
int              REAL(shutdown)     P((S5IOHandle, int));

#endif /* FOR_SHARED_LIBRARY */
#endif /* HAVE_DLOPEN        */
#endif /* IN_LIBRARY         */

#ifndef REAL
#define REAL(x) x
#endif

#ifdef USE_SOCKS4_PREFIX
#define LIBPREFIX2(x)  R ## x
#else
#define LIBPREFIX2(x)  SOCKS ## x
#endif

#ifndef LIBPREFIX
#define LIBPREFIX(x) LIBPREFIX2(x)
#endif

#endif

